@extends('user.layouts.master')
@section('css')
    <style>
        .shadow-sm {
            display: none !important;
        }
    </style>
@endsection
@section('user-content')
    <div class="container-fluid mt-2">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-md-8 col-12">
                <div class="alert alert-success bg-warning text-white border-0">
                    <marquee scrollamount="6">
                        @foreach ($headlines as $key=>$headline)
                            <a href="{{ $headline->link }}" class="text-black" style="font-size:20px;"><i class="fe fe-link me-2 white-text" aria-hidden="true"></i>{{ $headline->title }}</a>
                        @endforeach
                    </marquee>
                </div>
            </div>
        </div>
    </div>
    <div class="card mt-2">
        <div class="card-header d-flex justify-content-between align-items-center">
            <div class="card-title h4">Service History</div>
            <!-- Order New Service Button -->
            <a href="{{route('user.boost-create')}}" class="btn btn-md btn-info">Order New Service</a>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered text-nowrap" id="example1">
                    <thead>
                        <tr>
                            <th scope="col border-bottom-0" width="5%">ID</th>
                            <th scope="col border-bottom-0" width="8%">Date Time</th>
                            <th scope="col border-bottom-0">Link</th>
                            <th scope="col border-bottom-0" width="8%">Charge</th>
                            <th scope="col border-bottom-0" width="8%">Quantity</th>
                            <th scope="col border-bottom-0" width="8%">Service</th>
                            <th scope="col border-bottom-0" width="8%">Reason</th>
                            <th scope="col border-bottom-0" width="8%">Status</th>
                            <th scope="col border-bottom-0" width="8%">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($datas as $key => $data)
                            <tr>
                                <td>{{ $data->id }}</td>
                                <td>
                                    {{ \Carbon\Carbon::parse($data->created_at)->format('d/m/Y g:i A')}}
                                </td>
                                <td><a href="{{ $data->link }}" target="_blank">{{ $data->link }}</a></td>
                                <td>{{ $data->cost }}$</td>
                                <td>{{ $data->work_need }}</td>
                                <td>{{ sub_boost_category($data->sub_category) }}</td>
                                <td>{{ $data->reason }}</td>
                                <td>
                                    @if ($data->status == 1)
                                        <span class="badge bg-success">Process</span>
                                    @elseif ($data->status == 2)
                                        <span class="badge bg-danger">Inprocess</span>
                                    @elseif ($data->status == 3)
                                        <span class="badge bg-danger">Reject</span>
                                    @elseif ($data->status == 4)
                                        <span class="badge bg-success">Complete</span>
                                    @else
                                        <span class="badge bg-danger">Pending</span>
                                    @endif
                                </td>
                                <td>
                                    @if ($data->status == 0)
                                        <a href="{{ route('user.boost-edit', $data->id) }}" class="btn btn-sm btn-success">Edit</a>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $datas->links() }}
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        function updateJobWorker(id){
            $('#worker_need_'+id).modal('show');
        }

        function updateJobWorkerMosdalClose(id){
            $('#worker_need_'+id).modal('hide');
        }
    </script>
@endsection
